// ***********************************************************************
//
// MyListNode Class Interface
//
// ***********************************************************************
// Computer Science 102: Data Structures
// New York University, Fall 2013,
//
// Lecturers: Eric Koskinen and Daniel Schwartz-Narbonne
//
// (c) Copyright 1995, 2013, Oracle Corporation and/or its affiliates (Oracle).
// All rights reserved.
// http://docs.oracle.com/javase/tutorial/information/license.html
// ***********************************************************************

import java.lang.*;

public class MyListNode<T> {
    protected T value;
    protected MyListNode<T> next;

    public MyListNode(T v, MyListNode<T> n) {
	value = v ; next = n ;
    }
    public MyListNode(T v) { value = v; next = null; }

    // Basic operations
    public int size() {
	if (next == null) return 1;
	else return 1 + next.size();
    }

    // *******************************************************
    // Insert/Remove from the Back
    // *******************************************************

    // removeBack(): scans until it finds the second-to-last node so that
    // it can remove the last node.
    public T removeBack() {
	// we got to the last node. this is a problem.
	if (next == null) 
	    System.out.println("error!\n");

	// ok, we are at the second-to-last node. make a reference (rv) to 
	// next.value, set next to be null (thereby eliminating the last node)
	// and then return the referenced value rv
	if (next.next == null) {
	    T rv = next.value;
	    next = null;
	    return value;
	} else {
	    // haven't made it to the second-to-last node yet, keep searching
	    return next.removeBack();
	}
    }

    // insertBack(): find the last node and give it a next node.
    public boolean insertBack(T e) {
	if (next == null) {
	    next = new MyListNode<T>(e);
	    return true;
	} else {
	    return next.insertBack(e);
	}
    }

    // Output operations
    public String toString() {
	return value.toString() + ( next == null ? "" : ", " + next.toString() );
    }
    public void PrettyPrint() {
	System.out.print(value);
	if(next != null) {
	    System.out.print(", ");
	    next.PrettyPrint();
	}
    }
}
